﻿using AZVIC.Ei8htPOS.BAL;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.POSRetail.Constants;
using AZVIC.Ei8htPOS.POSRetail.Helpers;
using AZVIC.Ei8htPOS.Utilities;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;

namespace AZVIC.Ei8htPOS.POSRetail.Controls
{
    /// <summary>
    /// Interaction logic for SelectTable.xaml
    /// </summary>
    public partial class SelectTable : Window
    {
        static List<Layouts> AllTables;
        public SelectTable()
        {
            InitializeComponent();
            LoadTable();
        }

        private void LoadTable()
        {
            AllTables = LayoutBL.GetList(Guid.Empty);
            if (AllTables != null && AllTables.Count > 0)
            {
                AllTables = AllTables.Where(a => a.IsActive).ToList<Layouts>();
            }
            dgTables.ItemsSource = AllTables;
            icTableList.ItemsSource = AllTables;
        }

        private void btnSelectTable_Click(object sender, RoutedEventArgs e)
        {
            Button btn = sender as Button;
            Guid TableID = Guid.Parse(btn.Tag.ToString());
            AppSession.CurrentOrders.TableNumber = AllTables.Where(a => a.TableID == TableID).Select(a => a.TableName).Single();
            this.Tag = true;
            this.Close();
        }

        protected void btnCancel_Click(object sender, RoutedEventArgs e)
        {
            this.Tag = false;
            this.Close();
        }

        private void btnAddTable_Click(object sender, RoutedEventArgs e)
        {
            if (Validate())
            {
                Layouts newTable = new Layouts();
                newTable.TableName = txtTableNumber.Text.Trim();
                newTable.IsActive = true;
                newTable.TableCapacity = string.IsNullOrEmpty(txtNumberOfSeats.Text) ? 0 : int.Parse(txtNumberOfSeats.Text);

                if (AllTables == null)
                {
                    AllTables = new List<Layouts>();
                }
                else if (AllTables.Where(a => a.TableName.Equals(newTable.TableName)).Any())
                {
                    MessageBox.Show("Table already exist. Please check the table name");
                    return;
                }
                LayoutBL.Save(newTable);
                LoadTable();
                MessageBox.Show("Table added to the list successfully!");
                txtNumberOfSeats.Clear();
                txtTableNumber.Clear();

            }
        }

        private bool Validate()
        {
            if (!ValidationUtility.ValidateString(txtTableNumber.Text.Trim()))
            {
                txtTableNumber.Focus();
                MessageBox.Show("Please enter Table Number");
                return false;
            }
            if (!string.IsNullOrEmpty(txtNumberOfSeats.Text.Trim()))
            {
                if (!ValidationUtility.ValidateInt(txtNumberOfSeats.Text.Trim()))
                {
                    txtNumberOfSeats.Focus();
                    MessageBox.Show("Please enter a valid number in number of seats field.");
                    return false;
                }
            }
            return true;
        }

        private void btnDeleteTable_Click(object sender, RoutedEventArgs e)
        {
            Button btn = sender as Button;
            Guid TableID = Guid.Parse(btn.Tag.ToString());
            LayoutBL.Delete(TableID);
            LoadTable();
            MessageBox.Show("Table removed successfully!");
        }

        private void btnRemoveTable_Click_1(object sender, RoutedEventArgs e)
        {
            if (dgTables.SelectedItem != null)
            {
                Layouts selectedItem = (Layouts)dgTables.SelectedItem;
                if (LayoutBL.Delete(selectedItem.TableID))
                {
                    LoadTable();
                    MessageBox.Show("Table removed successfully");
                }
            }
        }

        
    }
}
